#ifndef _ECG_DSC
#define _ECG_DSC


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "PublicTypes.h"
#include "SwTimer.h"
#include "IICV1Driver.h"

#define DSC_SLAVE_ADDRESS		(0x02 << 1)
#define DATA_LENGTH_FROM_DSC	66	//bytes to read from the DSC

#define	PACKET_ID_POSITION		0
#define CHECKSUM_POSITION		1
#define DATA_START_POSITION		2
#define DATA_END_POSITION		DATA_LENGTH_FROM_DSC



extern UINT8 Ecg_HeartRate;
extern UINT8 DataFromDsc[];

extern const pFunc_t EcgDsc_Events[];	//the easy way

void EcgDsc_Init(void);
UINT8 EcgDsc_DiagnosticModeStartMeasurement(void);
UINT8 EcgDsc_HeartRateStartMeasurement(void);
void EcgDsc_DiagnosticModeStopMeasurement(void);
void EcgDsc_PeriodicTask(void);
	  


#endif //_ECG_DSC